#ifndef EVAL_H
#define EVAL_H

#include "board.h"
#include "material.h"
#include "pawntab.h"


struct sEvOpt {
	bool pawns;
	bool bishops;
	bool knights;
	bool rooks;
	bool queens;
	bool psqt;
	bool blocked;
	bool development;
	bool balance;
};

class cEval {

 private:

 uint pawnfiles[numcolours];
 int pawns[2][2];
 int score[2][2];
 int mob[2][2];
 int dev[2][2];
 int blo[2][2];
 int pos[2][2];
 int bal[2][2];

 bool hashhit;
 bool drawflag;


 cEval( const cEval & );
        cEval &operator = ( const cEval & );


 void score_pawn(cBoard &brd, cMaterial &mat, cPawntable &pawntab);
 //void score_bishops(cBoard &brd, cMaterial &mat);
 //void score_knights(cBoard &brd, cMaterial &mat);
 void score_queens(cBoard &brd, cMaterial &mat);
 void score_rooks(cBoard &brd, cMaterial &mat);
 void balance(cBoard &brd, cMaterial &mat);
 bool is_draw(cBoard &brd, cMaterial &mat);
 void setpawns(const bool set) { opt->pawns = set; }
 void setknights(const bool set) { opt->knights = set; }
 void setbishops(const bool set) { opt->bishops = set; }
 void setpsqt(const bool set) { opt->psqt = set; }

 void score_blocked(cBoard &brd);
 void score_development(cBoard &brd);

 public:

 cEval();

 void reset_all_arrays();

 int eval(cBoard &brd, cMaterial &mat, cPawntable &pawntab);
 int lazyeval(cBoard &brd, cMaterial &mat);
 void init_opt();
 void init_mobility();

 void logeval(cBoard &brd, cMaterial &mat, cPawntable &pawntab);

 /** eval weights **/
 static int doubledopen;
 static int doubledend;
 static int isolatedopen;
 static int isolatedend;
 static int openfileopen;
 static int openfileend;
 static int passeropen;
 static int passerend;
 static int bishopmobmin;
 static int bishopmobmax;
 static int knightmobmin;
 static int knightmobmax;
 static int rookmobmin;
 static int rookmobmax;
 static int queenmobmin;
 static int queenmobmax;


 static int rookopenfile;
 static int rooksemiopenfile;
 static int rookseventhrank;
 static int queenseventhrank;


 static int bishopmob[14];
 static int knightmob[8];
 static int queenmob[28];
 static int rookmob[14];

 static int pin;

 static int trR;
 static int trP;
 static int trB;

 static int minordev;
 static int majorsoon;

 sEvOpt opt[1];

};






#endif

